package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.ComunicacionPrl;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.OS2;
import com.ejie.ct.xml.FolderDocumentList;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * OS2Service generated by UDA, 28-feb-2017 16:03:08.
 * 
 * @author UDA
 */

public interface OS2Service {

	/**
	 * Inserts a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	OS2 add(OS2 ab0460s00);

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	OS2 update(OS2 ab0460s00);

	/**
	 * Finds a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	OS2 find(OS2 ab0460s00);

	/**
	 * Deletes a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 */
	void remove(OS2 ab0460s00);

	/**
	 * Finds a list of rows in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto List<Ab0460s00>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	List<OS2> findAll(OS2 ab0460s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0460s00 table using like.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0460s00>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<OS2> findAllLike(OS2 ab0460s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finds a list of rows in the Ab0427s00 table.
	 * 
	 * ab0427s00 Ab0427s00
	 * 
	 * List<DocumentoOS2>
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 * @return the list
	 */
	public List<DocumentoOS2> findAllDocumentosOS2TipoTemp(
			DocumentoOS2 ab0427s00);

	/**
	 * Finds a list of rows in the Ab0427s00 table.
	 * 
	 * ab0427s00 Ab0427s00
	 * 
	 * List<DocumentoOS2>
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 * @return the list
	 */
	// public List<DocumentoOS2> findAll(DocumentoOS2 ab0427s00);

	/**
	 * 
	 * Finds a list of rows in the Ab0427s00 table.
	 * 
	 * ab0427s00 Ab0427s00
	 * 
	 * List<DocumentoOS2>
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 * @return the list
	 */
	public List<DocumentoOS2> buscarDocumentosOS2Temp(DocumentoOS2 ab0427s00);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0460s00 table.
	 * 
	 * filterAb0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0460s00>
	 * 
	 * @param filterAb0460s00
	 *            the filter ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<OS2> filter(OS2 filterAb0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0460s00 table.
	 * 
	 * filterAb0460s00 Ab0460s00 searchAb0460s00 Ab0460s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0460s00>>
	 * 
	 * @param filterAb0460s00
	 *            the filter ab 0460 s 00
	 * @param searchAb0460s00
	 *            the search ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<TableRowDto<OS2>> search(OS2 filterAb0460s00, OS2 searchAb0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0460s00 table.
	 * 
	 * filterAb0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0460s00
	 *            the filter ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	Object reorderSelection(OS2 filterAb0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * comunicacionPrl ComunicacionPrl platea the platea OS2
	 * 
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @param platea
	 *            the platea
	 * @return the os2
	 */
	OS2 modificarDatosTabNotificacionOS2(ComunicacionPrl comunicacionPrl,
			boolean platea);

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	OS2 modificarDatosTabEmpresaOS2(OS2 os2);

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	OS2 modificarDatosTabModalidad(OS2 os2);

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	OS2 modificarDatosTabAuditoria(OS2 os2);

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	OS2 modificarDatosTabEstadoOS2(OS2 os2);

	/**
	 * Find by folder id.
	 * 
	 * folderId the folder id the os2
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os2
	 */
	OS2 findByFolderId(String folderId);

	/**
	 * Find by folder id 2.
	 * 
	 * folderId the folder id the os2
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os2
	 */
	OS2 findByFolderId2(String folderId);

	/**
	 * Alta comunicacion OS 2 presencial.
	 * 
	 * the os2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	OS2 altaComunicacionOS2Presencial(OS2 os2);

	/**
	 * Update filled.
	 * 
	 * os2 the os 2 the os2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	OS2 updateFilled(OS2 os2);

	/**
	 * Find datos registro.
	 * 
	 * os2 the os 2 the os2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	OS2 findDatosRegistro(OS2 os2);

	/**
	 * Modificar datos registro.
	 * 
	 * os2_reg the os 2 reg the os2
	 * 
	 * @param os2_reg
	 *            the os 2 reg
	 * @return the os2
	 */
	OS2 modificarDatosRegistro(OS2 os2_reg);

	/**
	 * Update usuarios tramitacion.
	 * 
	 * os2 the os 2
	 * 
	 * @param os2
	 *            the os 2
	 */
	void updateUsuariosTramitacion(OS2 os2);

	/**
	 * Update estado.
	 * 
	 * os2 the os 2
	 * 
	 * @param os2
	 *            the os 2
	 */
	void updateEstado(OS2 os2);

	void updateBatchSub(OS2 os2);

	void updateFecSub(OS2 os2);

	/**
	 * Obtener documentos migrados.
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the folder document list
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ComunicacionAperturaService#
	 * obtenerDocumentosMigrados(java.lang.String)
	 */
	// @Override()
	public FolderDocumentList obtenerDocumentosMigrados(String folderId);
}
